/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez;

import de.maxhenkel.pipez.DirectionalPosition;
import de.maxhenkel.pipez.Filter;
import de.maxhenkel.pipez.corelib.tag.SingleElementTag;
import de.maxhenkel.pipez.utils.GasUtils;
import java.util.UUID;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.gas.Gas;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;

public class GasFilter
extends Filter<Gas> {
    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        if (this.tag != null) {
            if (this.tag instanceof SingleElementTag) {
                ResourceLocation key = MekanismAPI.gasRegistry().getKey((Object)((Gas)((SingleElementTag)this.tag).getElement()));
                if (key != null) {
                    compound.m_128359_("Gas", key.toString());
                }
            } else {
                compound.m_128359_("Tag", this.tag.getName().toString());
            }
        }
        if (this.destination != null) {
            compound.m_128365_("Destination", (Tag)this.destination.serializeNBT());
        }
        if (this.invert) {
            compound.m_128379_("Invert", true);
        }
        compound.m_128362_("ID", this.id);
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        this.tag = null;
        if (compound.m_128425_("Gas", 8)) {
            ResourceLocation rl = new ResourceLocation(compound.m_128461_("Gas"));
            Gas gas = (Gas)MekanismAPI.gasRegistry().getValue(rl);
            if (gas != null) {
                this.tag = new SingleElementTag<Gas>(rl, gas);
            }
        }
        if (compound.m_128425_("Tag", 8)) {
            this.tag = GasUtils.getGasTag(compound.m_128461_("Tag"), false);
        }
        this.metadata = null;
        this.exactMetadata = false;
        if (compound.m_128425_("Destination", 10)) {
            this.destination = new DirectionalPosition();
            this.destination.deserializeNBT(compound.m_128469_("Destination"));
        } else {
            this.destination = null;
        }
        this.invert = compound.m_128425_("Invert", 1) ? compound.m_128471_("Invert") : false;
        this.id = compound.m_128425_("ID", 11) ? compound.m_128342_("ID") : UUID.randomUUID();
    }
}

